﻿using BMS.ServiceContracts;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using BMS.DataContracts;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.BMService;
using System.Collections.Generic;
using System.Linq;

namespace BMS.UnitTesting
{
    /// <summary>
    ///This is a test class for ConfigurationOperations and is intended
    ///to contain all ConfigurationOperations Unit Tests
    ///</summary>
    [TestClass()]
    public class ConfigurationOperations
    {
        private TestContext testContextInstance;
        const string domainId = "InfoWorld";
        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        internal virtual IConfigurationOperations CreateIConfigurationOperations()
        {
            IConfigurationOperations target = BMSFactory.ConfigurationOperationsClient;
            return target;
        }

        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        [ClassInitialize()]
        public static void MyClassInitialize(TestContext testContext)
        {
            ServicesControl.Init();
        }

        /// <summary>
        /// Test method for creating default user profile configuration with ST value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating default user profile configuration with ST value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateDefaultUserProfile()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(2, ConfigType.DEFUSR, BasicType.ST);
            target.SetUserProfile(config);
            Configuration configResult = target.GetDefaultProfile(config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new user profile configuration.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new user profile configuration.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateUserProfile()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(3, ConfigType.USR, BasicType.ST);
            target.SetUserProfile(config);
            Configuration configResult = target.GetUserProfile(config.UserName, config.Domain);            
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new user profile configuration with INT value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new user profile configuration with INT value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateUserProfile_INT()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(1, ConfigType.USR, BasicType.INT);
            target.SetUserProfile(config);
            Configuration configResult = target.GetUserProfile(config.UserName, config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new user profile configuration with BL value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new user profile configuration with BL value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateUserProfile_BL()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(4, ConfigType.USR, BasicType.BL);
            target.SetUserProfile(config);
            Configuration configResult = target.GetUserProfile(config.UserName, config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new user profile configuration with TS value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new user profile configuration with TS value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateUserProfile_TS()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(5, ConfigType.USR, BasicType.TS);
            target.SetUserProfile(config);
            Configuration configResult = target.GetUserProfile(config.UserName, config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new user profile configuration with REAL value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new user profile configuration with REAL value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateUserProfile_REAL()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(6, ConfigType.USR, BasicType.REAL);
            target.SetUserProfile(config);
            Configuration configResult = target.GetUserProfile(config.UserName, config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new user profile configuration with EVS value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new user profile configuration with EVS value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateUserProfile_EVS()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(7, ConfigType.USR, BasicType.EVS);
            target.SetUserProfile(config);
            Configuration configResult = target.GetUserProfile(config.UserName, config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new user profile configuration with EIS value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new user profile configuration with EIS value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateUserProfile_EIS()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(8, ConfigType.USR, BasicType.EIS);
            target.SetUserProfile(config);
            Configuration configResult = target.GetUserProfile(config.UserName, config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating default application configuration.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating default application configuration.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateDefaultApplicationConfiguration()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(2, ConfigType.DEFAPP, BasicType.ST);
            target.SetApplicationConfiguration(config);
            Configuration configResult = target.GetDefaultApplicationConfiguration(config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new application configuration with ST value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new application configuration with ST value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateApplicationConfiguration()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(3, ConfigType.APP, BasicType.ST);
            target.SetApplicationConfiguration(config);
            Configuration configResult = target.GetApplicationConfiguration(config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new application configuration with INT value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new application configuration with INT value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateApplicationConfiguration_INT()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(1, ConfigType.APP, BasicType.INT);
            target.SetApplicationConfiguration(config);
            Configuration configResult = target.GetApplicationConfiguration(config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new application configuration with BL value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new application configuration with BL value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateApplicationConfiguration_BL()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(4, ConfigType.APP, BasicType.BL);
            target.SetApplicationConfiguration(config);
            Configuration configResult = target.GetApplicationConfiguration(config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new application configuration with TS value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new application configuration with TS value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateApplicationConfiguration_TS()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(5, ConfigType.APP, BasicType.TS);
            target.SetApplicationConfiguration(config);
            Configuration configResult = target.GetApplicationConfiguration(config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new application configuration with REAL value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new application configuration with REAL value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateApplicationConfiguration_REAL()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(6, ConfigType.APP, BasicType.REAL);
            target.SetApplicationConfiguration(config);
            Configuration configResult = target.GetApplicationConfiguration(config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new application configuration with EVS value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new application configuration with EVS value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateApplicationConfiguration_EVS()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(7, ConfigType.APP, BasicType.EVS);
            target.SetApplicationConfiguration(config);
            Configuration configResult = target.GetApplicationConfiguration(config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for creating a new application configuration with EIS value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new application configuration with EIS value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void CreateApplicationConfiguration_EIS()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(8, ConfigType.APP, BasicType.EIS);
            target.SetApplicationConfiguration(config);
            Configuration configResult = target.GetApplicationConfiguration(config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult));
        }

        /// <summary>
        /// Test method for updating default user profile configuration with ST value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for updating default user profile configuration with ST value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void UpdateDefaultUserProfile()
        {            
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(2, ConfigType.DEFUSR, BasicType.ST);
            Configuration configResult = target.GetDefaultProfile(config.Domain);
            config.SectionList[config.SectionList.Keys.ElementAt(0)].Add(configResult.SectionList[configResult.SectionList.Keys.ElementAt(0)][0]);
            config.SectionList[config.SectionList.Keys.ElementAt(0)][config.SectionList[config.SectionList.Keys.ElementAt(0)].Count - 1].Value = config.SectionList[config.SectionList.Keys.ElementAt(0)][0].Value;
            config.SectionList[config.SectionList.Keys.ElementAt(0)][config.SectionList[config.SectionList.Keys.ElementAt(0)].Count - 1].FriendlyName = config.SectionList[config.SectionList.Keys.ElementAt(0)][0].FriendlyName;
            target.SetUserProfile(config);
            Configuration configResult2 = target.GetDefaultProfile(config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult2));
        }

        /// <summary>
        /// Test method for updating an existing user profile configuration with EVS value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for updating an existing user profile configuration with EVS value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void UpdateUserProfile_EVS()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(7, ConfigType.USR, BasicType.EVS);
            Configuration configResult = target.GetUserProfile(config.UserName, config.Domain);
            config.SectionList[config.SectionList.Keys.ElementAt(0)].Add(configResult.SectionList[configResult.SectionList.Keys.ElementAt(0)][0]);
            config.SectionList[config.SectionList.Keys.ElementAt(0)][config.SectionList[config.SectionList.Keys.ElementAt(0)].Count - 1].Value = config.SectionList[config.SectionList.Keys.ElementAt(0)][0].Value;
            config.SectionList[config.SectionList.Keys.ElementAt(0)][config.SectionList[config.SectionList.Keys.ElementAt(0)].Count - 1].FriendlyName = config.SectionList[config.SectionList.Keys.ElementAt(0)][0].FriendlyName;
            target.SetUserProfile(config);
            Configuration configResult2 = target.GetUserProfile(config.UserName, config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult2));
        }

        /// <summary>
        /// Test method for updating default application configuration.
        ///</summary>
        [TestMethod()]
        [Description("Test for updating default application configuration.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void UpdateDefaultApplicationConfiguration()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(2, ConfigType.DEFAPP, BasicType.ST);
            Configuration configResult = target.GetDefaultApplicationConfiguration(config.Domain);
            config.SectionList[config.SectionList.Keys.ElementAt(0)].Add(configResult.SectionList[configResult.SectionList.Keys.ElementAt(0)][0]);
            config.SectionList[config.SectionList.Keys.ElementAt(0)][config.SectionList[config.SectionList.Keys.ElementAt(0)].Count - 1].Value = config.SectionList[config.SectionList.Keys.ElementAt(0)][0].Value;
            config.SectionList[config.SectionList.Keys.ElementAt(0)][config.SectionList[config.SectionList.Keys.ElementAt(0)].Count - 1].FriendlyName = config.SectionList[config.SectionList.Keys.ElementAt(0)][0].FriendlyName;
            target.SetApplicationConfiguration(config);
            Configuration configResult2 = target.GetDefaultApplicationConfiguration(config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult2));
        }

        /// <summary>
        /// Test method for updating an existing application configuration with EIS value type.
        ///</summary>
        [TestMethod()]
        [Description("Test for updating an existing application configuration with EIS value type.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void UpdateApplicationConfiguration_EIS()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();
            Configuration config = Builders.BuildConfiguration(8, ConfigType.APP, BasicType.EIS);
            Configuration configResult = target.GetApplicationConfiguration(config.Domain);
            config.SectionList[config.SectionList.Keys.ElementAt(0)].Add(configResult.SectionList[configResult.SectionList.Keys.ElementAt(0)][0]);
            config.SectionList[config.SectionList.Keys.ElementAt(0)][config.SectionList[config.SectionList.Keys.ElementAt(0)].Count - 1].Value = config.SectionList[config.SectionList.Keys.ElementAt(0)][0].Value;
            config.SectionList[config.SectionList.Keys.ElementAt(0)][config.SectionList[config.SectionList.Keys.ElementAt(0)].Count - 1].FriendlyName = config.SectionList[config.SectionList.Keys.ElementAt(0)][0].FriendlyName;
            target.SetApplicationConfiguration(config);
            Configuration configResult2 = target.GetApplicationConfiguration(config.Domain);
            Assert.IsTrue(new ConfigurationComparer().Equals(config, configResult2));
        }

        /// <summary>
        /// Test method for restoring an application configuration to the default configuration.
        ///</summary>
        [TestMethod()]
        [Description("Test for restoring an application configuration to the default configuration.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void ResetApplicationConfiguration()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();                        
            Configuration configResult = target.ResetApplicationConfiguration(domainId);
            Configuration configResult2 = target.GetApplicationConfiguration(domainId);
            Assert.IsTrue(new ConfigurationComparer().Equals(configResult, configResult2));
        }

        /// <summary>
        /// Test method for restoring a user profile to the default configuration.
        ///</summary>
        [TestMethod()]
        [Description("Test for restoring a user profile to the default configuration.")]
        [TestCategory(Constants.IConfigurationOperations)]
        public void ResetUserProfile()
        {
            IConfigurationOperations target = CreateIConfigurationOperations();            
            Configuration configResult = target.ResetUserProfile("user 3", domainId);
            Configuration configResult2 = target.GetUserProfile("user 3", domainId);
            Assert.IsTrue(new ConfigurationComparer().Equals(configResult, configResult2));
        }
    }
}
